/*****************************************************************************
* 
* NXP Confidential Proprietary
*
* Copyright (c) 2014-2016 Freescale Semiconductor
* Copyright 2017-2019 NXP 
* All Rights Reserved
*
******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/
#ifndef APUCONVOLUTIONPROCESS_H
#define APUCONVOLUTIONPROCESS_H

#include "common_base_process_init.h"
#include "apu_convolution_graph_names.h"

#ifdef APEX2_EMULATE
#include "apu_convolution_apu_process_desc.hpp"
REGISTER_PROCESS_TYPE(CONVOLUTION_PI, Apu_Convolution_Apu_Process_Desc)
#else

#include str_header(CONVOLUTION_PI,hpp)
#endif
#include <umat.hpp>

// ////////Includes for convolution
#include "utils_filter.hpp"
using namespace Convolution;
#include "symmetry_flags.h"

template <int filtW, int filtH, class dataTp>
class CConvolution_Proc : public CBase_ProcInit<CONVOLUTION_PI> {
private:
public:	// Input params
	
	vsdk::UMat lInput;

	/*Output data is generated by this process*/
	vsdk::UMat  lOutput;
	
	vsdk::UMat  filtData;
	vsdk::UMat  filtScale;
	//vsdk::UMat  filtWidth;
	//vsdk::UMat  filtHeight;
	vsdk::UMat  filtSymFlag;
	
public:
	CConvolution_Proc(int apex_id = APEX_APEX0)
	: CBase_ProcInit<CONVOLUTION_PI>(apex_id)
	{		
	}

	CConvolution_Proc(vsdk::UMat input, const CFilter<filtW, filtH, dataTp>* filt, int apex_id = APEX_APEX0)
		: CBase_ProcInit<CONVOLUTION_PI>(apex_id)
	{
		InitData(input, filt);
		Connect();
	}
		
	virtual ~CConvolution_Proc();

	int InitData(vsdk::UMat input, const CFilter<filtW, filtH, dataTp>* filt);

	int Connect();
	
};

#include "apu_convolution_graph_names.h"


template <int filtW, int filtH, class dataTp>
CConvolution_Proc<filtW, filtH, dataTp>::~CConvolution_Proc()
{
}

template <int filtW, int filtH, class dataTp>
int CConvolution_Proc<filtW, filtH, dataTp>::InitData(vsdk::UMat input, const CFilter<filtW, filtH, dataTp>* filt)
{
	lInput = input;

	size_t		 filtSz = filt->size();

	lOutput = vsdk::UMat(lInput.rows, lInput.cols, VSDK_CV_16SC1);
    memset(lOutput.getMat(vsdk::ACCESS_WRITE | OAL_USAGE_CACHED).data, '\0', lOutput.step[1]*lOutput.rows);

	
	filtData = vsdk::UMat(filtH, filtW, VSDK_CV_16SC1);
	filtScale = vsdk::UMat(1, 1, VSDK_CV_16SC1);
	filtSymFlag = vsdk::UMat(1, 1, VSDK_CV_16UC1);

	m_errVal |= (lOutput.empty());
	m_errVal |= (filtData.empty());
	m_errVal |= (filtScale.empty());
	m_errVal |= (filtSymFlag.empty());
	
	memcpy(filtData.getMat(vsdk::ACCESS_WRITE | OAL_USAGE_CACHED).data, filt->dataVect(), filtSz);
	filtScale.getMat(vsdk::ACCESS_WRITE | OAL_USAGE_CACHED).at<short>(0) = (short) filt->ScalingFact();
    filtSymFlag.getMat(vsdk::ACCESS_WRITE | OAL_USAGE_CACHED).at<unsigned short>(0) = SYMMFLAG(filt->isSymX(), filt->isSymY(), filt->isAntiSymX(), filt->isAntiSymY());

	return m_errVal;
	
}


template <int filtW, int filtH, class dataTp>
int CConvolution_Proc<filtW, filtH, dataTp>::Connect()
{

#ifdef APEX2_EMULATE
	cout << "\nInitializing graph:" << CONVOLUTION_GN << endl;
#endif

	m_errVal |= Initialize();

	m_errVal |= ConnectIO(CONVOLUTION_GRAPH_IN, lInput);
	m_errVal |= ConnectIO(CONVOLUTION_GRAPH_OUT, lOutput);
	m_errVal |= ConnectIO(CONVOLUTION_GRAPH_IN_FILTER, filtData);

	m_errVal |= ConnectIO(CONVOLUTION_GRAPH_FILTER_SCALE, filtScale);
	m_errVal |= ConnectIO(CONVOLUTION_GRAPH_FILTER_SYMMFLG, filtSymFlag);


#ifdef APEX2_EMULATE
	cout << CONVOLUTION_GN << " graph Plan: " << endl;
	cout << GetExecutionPlanDescription() << endl;
#endif


#ifdef APEX2_EMULATE
	if (m_errVal)
	{
		std::cout << CONVOLUTION_GN << " plan error!" << endl;
		std::cout << ErrorMessage() << endl;
		char c;
		std::cin >> c;
	}
#endif

	return m_errVal;
}




#endif /* APUCONVOLUTIONPROCESS_H */
